package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * reason_for_invalidation
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum ReasonForInvalidation {

    客户主动取消("客户主动取消", "客户主动取消"),
    替代解决("替代解决", "替代解决"),
    说服客户取消("说服客户取消", "说服客户取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReasonForInvalidation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReasonForInvalidation fromCode(String code){
        switch(code) {
            case "客户主动取消":
                return 客户主动取消;
            case "替代解决":
                return 替代解决;
            case "说服客户取消":
                return 说服客户取消;
            default:
                return null;
        }
    }
}
