package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * task_level
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum TaskLevel {

    P0("P0", "P0"),
    P1("P1", "P1"),
    P2("P2", "P2");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaskLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskLevel fromCode(String code){
        switch(code) {
            case "P0":
                return P0;
            case "P1":
                return P1;
            case "P2":
                return P2;
            default:
                return null;
        }
    }
}
