package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * task_scenario
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum TaskScenario {

    _2("2", "范围内迭代"),
    _3("3", "需求变更"),
    _5("5", "新需求-CR"),
    _6("6", "新需求-免费"),
    _7("7", "功能问题"),
    _8("8", "性能问题"),
    _9("9", "接口问题"),
    _10("10", "任务");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaskScenario(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskScenario fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "3":
                return _3;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
