package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * value_secondary_classification
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum ValueSecondaryClassification {

    _1("1", "展示/查询/文案等"),
    _2("2", "导入/导出/编辑等"),
    _3("3", "产品版本差异补齐"),
    _4("4", "新场景"),
    _5("5", "集成接口"),
    _6("6", "迁移升级"),
    _7("7", "产品版本差异补齐"),
    _8("8", "报表统计"),
    _9("9", "业务规则"),
    _10("10", "审批"),
    _11("11", "审计"),
    _12("12", "产品版本差异补齐"),
    _13("13", "数电国税基础能力"),
    _14("14", "数电产品定制能力"),
    _15("15", "其他政策"),
    _16("16", "内部降case"),
    _17("17", "内部对账"),
    _18("18", "内部运维"),
    _19("19", "数据增值"),
    _20("20", "资金节约效益");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ValueSecondaryClassification(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ValueSecondaryClassification fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            default:
                return null;
        }
    }
}
