package com.xforceplus.psccreqmgmt.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CustomerInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 客户编码
   */
  @TableField("customerCode")
  private String customerCode;

  /**
   * 客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 免费额度
   */
  @TableField("freeAvailableAmount")
  private BigDecimal freeAvailableAmount;

  /**
   * 已用额度
   */
  @TableField("theAmountUsed")
  private BigDecimal theAmountUsed;

  /**
   * 剩余额度
   */
  @TableField("availableAmount")
  private BigDecimal availableAmount;

  /**
   * 客户optionId
   */
  @TableField("customerId")
  private String customerId;

  /**
   * 是否同步
   */
  @TableField("ifSync")
  private String ifSync;

  /**
   * 客户行业
   */
  @TableField("customerIndustry")
  private String customerIndustry;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("customerCode", customerCode);
      map.put("customerName", customerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("freeAvailableAmount", freeAvailableAmount);
      map.put("theAmountUsed", theAmountUsed);
      map.put("availableAmount", availableAmount);
      map.put("customerId", customerId);
      map.put("ifSync", ifSync);
      map.put("customerIndustry", customerIndustry);

      return map;
  }

  public static CustomerInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CustomerInfo entity = new CustomerInfo();
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeAvailableAmount")) {
      Object obj = map.get("freeAvailableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreeAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreeAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreeAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreeAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreeAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("theAmountUsed")) {
      Object obj = map.get("theAmountUsed");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTheAmountUsed((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTheAmountUsed(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTheAmountUsed(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTheAmountUsed(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTheAmountUsed(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("availableAmount")) {
      Object obj = map.get("availableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerId")) {
      Object obj = map.get("customerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifSync")) {
      Object obj = map.get("ifSync");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIfSync((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerIndustry")) {
      Object obj = map.get("customerIndustry");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerIndustry((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freeAvailableAmount")) {
      Object obj = map.get("freeAvailableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFreeAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFreeAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFreeAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFreeAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreeAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("theAmountUsed")) {
      Object obj = map.get("theAmountUsed");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTheAmountUsed((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTheAmountUsed(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTheAmountUsed(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTheAmountUsed(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTheAmountUsed(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("availableAmount")) {
      Object obj = map.get("availableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customerId")) {
      Object obj = map.get("customerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ifSync")) {
      Object obj = map.get("ifSync");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIfSync((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerIndustry")) {
      Object obj = map.get("customerIndustry");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerIndustry((String)obj);
        }
      } else {
      }
    }
  }
}
