package com.xforceplus.psccreqmgmt.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PeriodizationInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 分期
   */
  @TableField("periodizationName")
  private String periodizationName;

  /**
   * 标签
   */
  private String labels;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 分期总额度
   */
  @TableField("aggregateQuota")
  private BigDecimal aggregateQuota;

  /**
   * 分期免费额度
   */
  @TableField("freeCredit")
  private BigDecimal freeCredit;

  /**
   * 项目
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 项目id
   */
  @TableField("projectId")
  private String projectId;

  /**
   * 分期Id
   */
  @TableField("periodId")
  private String periodId;

  /**
   * 分期optionId
   */
  @TableField("pro_perId")
  private String proPerid;

  /**
   * 是否同步
   */
  @TableField("ifSync")
  private String ifSync;


  /**
   * 对一关联关系 关联对象 customerInfo
   */
    private Long custAndPeriodRelationshipId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("periodizationName", periodizationName);
      map.put("labels", labels);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("aggregateQuota", aggregateQuota);
      map.put("freeCredit", freeCredit);
      map.put("projectName", projectName);
      map.put("projectId", projectId);
      map.put("periodId", periodId);
      map.put("pro_perId", proPerid);
      map.put("ifSync", ifSync);

       map.put("custAndPeriodRelationship.id", custAndPeriodRelationshipId);
      return map;
  }

  public static PeriodizationInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PeriodizationInfo entity = new PeriodizationInfo();
    if(map.containsKey("periodizationName")) {
      Object obj = map.get("periodizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPeriodizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("labels")) {
      Object obj = map.get("labels");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLabels((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aggregateQuota")) {
      Object obj = map.get("aggregateQuota");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAggregateQuota((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAggregateQuota(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAggregateQuota(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAggregateQuota(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAggregateQuota(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("freeCredit")) {
      Object obj = map.get("freeCredit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreeCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreeCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreeCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreeCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreeCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectId")) {
      Object obj = map.get("projectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodId")) {
      Object obj = map.get("periodId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPeriodId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pro_perId")) {
      Object obj = map.get("pro_perId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProPerid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifSync")) {
      Object obj = map.get("ifSync");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIfSync((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("custAndPeriodRelationship.id")) {
        Object obj = map.get("custAndPeriodRelationship.id");
      if(obj instanceof Long) {
        entity.setCustAndPeriodRelationshipId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setCustAndPeriodRelationshipId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("periodizationName")) {
      Object obj = map.get("periodizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPeriodizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("labels")) {
      Object obj = map.get("labels");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLabels((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("aggregateQuota")) {
      Object obj = map.get("aggregateQuota");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAggregateQuota((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAggregateQuota(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAggregateQuota(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAggregateQuota(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAggregateQuota(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("freeCredit")) {
      Object obj = map.get("freeCredit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFreeCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFreeCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFreeCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFreeCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreeCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectId")) {
      Object obj = map.get("projectId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("periodId")) {
      Object obj = map.get("periodId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPeriodId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pro_perId")) {
      Object obj = map.get("pro_perId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProPerid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ifSync")) {
      Object obj = map.get("ifSync");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIfSync((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("custAndPeriodRelationship.id")) {
        Object obj = map.get("custAndPeriodRelationship.id");
        if(obj instanceof Long) {
          this.setCustAndPeriodRelationshipId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustAndPeriodRelationshipId(Long.parseLong((String)obj));
        }
      }
  }
}
