package com.xforceplus.psccreqmgmt.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RequirementTask implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 客户信息
   */
  private String customerInformation;

  /**
   * 分期信息
   */
  private String stageInformation;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * JIRA号
   */
  private String jiraNumber;

  /**
   * 需求描述
   */
  private String taskDescribe;

  /**
   * 任务编号主键
   */
  private String taskNumberKey;

  /**
   * 优先级
   */
  private String taskLevel;

  /**
   * 项目标签
   */
  private String operationsTags;

  /**
   * 提出人
   */
  private String proposer;

  /**
   * 经办人部门
   */
  private String departmentTheProposerBelongs;

  /**
   * 预计开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime estimatedStartDate;

  /**
   * 预计结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime estimatedEndDate;

  /**
   * 上线时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualClosureDate;

  /**
   * 备注
   */
  private String remark;

  /**
   * 待删除
   */
  private String taskNumberKe2y;

  /**
   * 需求提出阶段
   */
  @TableField("pitchStage")
  private String pitchStage;

  /**
   * 经办人
   */
  @TableField("handlingPersonnel")
  private String handlingPersonnel;

  /**
   * 申请日期
   */
  @TableField("proposedTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime proposedTime;

  /**
   * 需求标题
   */
  @TableField("requirementTitle")
  private String requirementTitle;

  /**
   * 需求背景
   */
  @TableField("requirementBackground")
  private String requirementBackground;

  /**
   * 价值类型
   */
  @TableField("typeOfValue")
  private String typeOfValue;

  /**
   * 价值二级分类
   */
  @TableField("valueSecondaryClassification")
  private String valueSecondaryClassification;

  /**
   * 期望上线时间
   */
  @TableField("expectedGoLiveTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expectedGoLiveTime;

  /**
   * 评审时间
   */
  @TableField("judgingTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime judgingTime;

  /**
   * 关联需求JIRA号
   */
  @TableField("associateRequirementsJIRA")
  private String associateRequirementsJIRA;

  /**
   * 是否验收通过
   */
  @TableField("acceptanceOrNot")
  private String acceptanceOrNot;

  /**
   * 需求状态
   */
  private String status;

  /**
   * 评审备注
   */
  @TableField("judgingRemark")
  private String judgingRemark;

  /**
   * 评审结论
   */
  @TableField("judgingConclusions")
  private String judgingConclusions;

  /**
   * 作废原因
   */
  @TableField("reasonForInvalidation")
  private String reasonForInvalidation;

  /**
   * 验收未通过原因
   */
  @TableField("reasonForFailureAcceptance")
  private String reasonForFailureAcceptance;

  /**
   * 流转状态
   */
  @TableField("circulationStatus")
  private String circulationStatus;

  /**
   * 客户信息编码
   */
  private String customerInformationCode;

  /**
   * 分期信息编码
   */
  private String stageInformationCode;

  /**
   * 客户信息ID
   */
  private String customerInformationId;

  /**
   * 分期信息ID
   */
  private String stageInformationId;

  /**
   * 预估人天（人天）
   */
  @TableField("estimatedDays")
  private String estimatedDays;

  /**
   * 验收通过日期
   */
  @TableField("acceptanceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acceptanceDate;

  /**
   * 是否风险
   */
  @TableField("riskORNot")
  private String riskORNot;

  /**
   * 风险类型
   */
  @TableField("typeOfRisk")
  private String typeOfRisk;

  /**
   * 风险描述
   */
  @TableField("riskDescription")
  private String riskDescription;

  /**
   * 项目信息
   */
  private String projectInformation;

  /**
   * 排期时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime productSprintDate;

  /**
   * 提出人团队
   */
  private String departmentTheHandlingProposerBelongs;

  /**
   * 客户行业
   */
  private String industry;

  /**
   * 项目分类
   */
  @TableField("projectClassification")
  private String projectClassification;

  /**
   * 报工代码
   */
  @TableField("reimbursementCode")
  private String reimbursementCode;

  /**
   * 需求性质
   */
  @TableField("natureOfDemand")
  private String natureOfDemand;

  /**
   * 场景大类
   */
  @TableField("sceneCategories")
  private String sceneCategories;

  /**
   * 评审标签
   */
  @TableField("reviewLabels")
  private String reviewLabels;

  /**
   * 金钱价值（元）
   */
  @TableField("monetaryValue")
  private BigDecimal monetaryValue;


  /**
   * 对一关联关系 关联对象 customerInfo
   */
    private Long taskAndCustomerRelationshipId;
  /**
   * 对一关联关系 关联对象 periodizationInfo
   */
    private Long taskAndPeriodizationRelationshipId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("customer_information", customerInformation);
      map.put("stage_information", stageInformation);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("jira_number", jiraNumber);
      map.put("task_describe", taskDescribe);
      map.put("task_number_key", taskNumberKey);
      map.put("task_level", taskLevel);
      map.put("operations_tags", operationsTags);
      map.put("proposer", proposer);
      map.put("department_the_proposer_belongs", departmentTheProposerBelongs);
      map.put("estimated_start_date", BocpGenUtils.toTimestamp(estimatedStartDate));
      map.put("estimated_end_date", BocpGenUtils.toTimestamp(estimatedEndDate));
      map.put("actual_closure_date", BocpGenUtils.toTimestamp(actualClosureDate));
      map.put("remark", remark);
      map.put("task_number_ke2y", taskNumberKe2y);
      map.put("pitchStage", pitchStage);
      map.put("handlingPersonnel", handlingPersonnel);
      map.put("proposedTime", BocpGenUtils.toTimestamp(proposedTime));
      map.put("requirementTitle", requirementTitle);
      map.put("requirementBackground", requirementBackground);
      map.put("typeOfValue", typeOfValue);
      map.put("valueSecondaryClassification", valueSecondaryClassification);
      map.put("expectedGoLiveTime", BocpGenUtils.toTimestamp(expectedGoLiveTime));
      map.put("judgingTime", BocpGenUtils.toTimestamp(judgingTime));
      map.put("associateRequirementsJIRA", associateRequirementsJIRA);
      map.put("acceptanceOrNot", acceptanceOrNot);
      map.put("status", status);
      map.put("judgingRemark", judgingRemark);
      map.put("judgingConclusions", judgingConclusions);
      map.put("reasonForInvalidation", reasonForInvalidation);
      map.put("reasonForFailureAcceptance", reasonForFailureAcceptance);
      map.put("circulationStatus", circulationStatus);
      map.put("customer_information_code", customerInformationCode);
      map.put("stage_information_code", stageInformationCode);
      map.put("customer_information_id", customerInformationId);
      map.put("stage_information_id", stageInformationId);
      map.put("estimatedDays", estimatedDays);
      map.put("acceptanceDate", BocpGenUtils.toTimestamp(acceptanceDate));
      map.put("riskORNot", riskORNot);
      map.put("typeOfRisk", typeOfRisk);
      map.put("riskDescription", riskDescription);
      map.put("project_information", projectInformation);
      map.put("product_sprint_date", BocpGenUtils.toTimestamp(productSprintDate));
      map.put("department_the_handling_proposer_belongs", departmentTheHandlingProposerBelongs);
      map.put("industry", industry);
      map.put("projectClassification", projectClassification);
      map.put("reimbursementCode", reimbursementCode);
      map.put("natureOfDemand", natureOfDemand);
      map.put("sceneCategories", sceneCategories);
      map.put("reviewLabels", reviewLabels);
      map.put("monetaryValue", monetaryValue);

       map.put("taskAndCustomerRelationship.id", taskAndCustomerRelationshipId);
       map.put("taskAndPeriodizationRelationship.id", taskAndPeriodizationRelationshipId);
      return map;
  }

  public static RequirementTask fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RequirementTask entity = new RequirementTask();
    if(map.containsKey("customer_information")) {
      Object obj = map.get("customer_information");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stage_information")) {
      Object obj = map.get("stage_information");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStageInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jira_number")) {
      Object obj = map.get("jira_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiraNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_describe")) {
      Object obj = map.get("task_describe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_number_key")) {
      Object obj = map.get("task_number_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskNumberKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_level")) {
      Object obj = map.get("task_level");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operations_tags")) {
      Object obj = map.get("operations_tags");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperationsTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("proposer")) {
      Object obj = map.get("proposer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProposer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_the_proposer_belongs")) {
      Object obj = map.get("department_the_proposer_belongs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartmentTheProposerBelongs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("estimated_start_date")) {
      Object obj = map.get("estimated_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEstimatedStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEstimatedStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEstimatedStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEstimatedStartDate(null);
      }
    }
    if(map.containsKey("estimated_end_date")) {
      Object obj = map.get("estimated_end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEstimatedEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEstimatedEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEstimatedEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEstimatedEndDate(null);
      }
    }
    if(map.containsKey("actual_closure_date")) {
      Object obj = map.get("actual_closure_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualClosureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setActualClosureDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualClosureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActualClosureDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_number_ke2y")) {
      Object obj = map.get("task_number_ke2y");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskNumberKe2y((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pitchStage")) {
      Object obj = map.get("pitchStage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPitchStage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handlingPersonnel")) {
      Object obj = map.get("handlingPersonnel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandlingPersonnel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("proposedTime")) {
      Object obj = map.get("proposedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProposedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setProposedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProposedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProposedTime(null);
      }
    }
    if(map.containsKey("requirementTitle")) {
      Object obj = map.get("requirementTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequirementTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requirementBackground")) {
      Object obj = map.get("requirementBackground");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequirementBackground((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("typeOfValue")) {
      Object obj = map.get("typeOfValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTypeOfValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("valueSecondaryClassification")) {
      Object obj = map.get("valueSecondaryClassification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValueSecondaryClassification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expectedGoLiveTime")) {
      Object obj = map.get("expectedGoLiveTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpectedGoLiveTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpectedGoLiveTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpectedGoLiveTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpectedGoLiveTime(null);
      }
    }
    if(map.containsKey("judgingTime")) {
      Object obj = map.get("judgingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJudgingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setJudgingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJudgingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setJudgingTime(null);
      }
    }
    if(map.containsKey("associateRequirementsJIRA")) {
      Object obj = map.get("associateRequirementsJIRA");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssociateRequirementsJIRA((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acceptanceOrNot")) {
      Object obj = map.get("acceptanceOrNot");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcceptanceOrNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("judgingRemark")) {
      Object obj = map.get("judgingRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJudgingRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("judgingConclusions")) {
      Object obj = map.get("judgingConclusions");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJudgingConclusions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reasonForInvalidation")) {
      Object obj = map.get("reasonForInvalidation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReasonForInvalidation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reasonForFailureAcceptance")) {
      Object obj = map.get("reasonForFailureAcceptance");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReasonForFailureAcceptance((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("circulationStatus")) {
      Object obj = map.get("circulationStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCirculationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_information_code")) {
      Object obj = map.get("customer_information_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerInformationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stage_information_code")) {
      Object obj = map.get("stage_information_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStageInformationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_information_id")) {
      Object obj = map.get("customer_information_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerInformationId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stage_information_id")) {
      Object obj = map.get("stage_information_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStageInformationId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("estimatedDays")) {
      Object obj = map.get("estimatedDays");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEstimatedDays((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acceptanceDate")) {
      Object obj = map.get("acceptanceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcceptanceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcceptanceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcceptanceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcceptanceDate(null);
      }
    }
    if(map.containsKey("riskORNot")) {
      Object obj = map.get("riskORNot");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskORNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("typeOfRisk")) {
      Object obj = map.get("typeOfRisk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTypeOfRisk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("riskDescription")) {
      Object obj = map.get("riskDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project_information")) {
      Object obj = map.get("project_information");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_sprint_date")) {
      Object obj = map.get("product_sprint_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProductSprintDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setProductSprintDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProductSprintDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProductSprintDate(null);
      }
    }
    if(map.containsKey("department_the_handling_proposer_belongs")) {
      Object obj = map.get("department_the_handling_proposer_belongs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartmentTheHandlingProposerBelongs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("industry")) {
      Object obj = map.get("industry");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIndustry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectClassification")) {
      Object obj = map.get("projectClassification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectClassification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursementCode")) {
      Object obj = map.get("reimbursementCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReimbursementCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("natureOfDemand")) {
      Object obj = map.get("natureOfDemand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNatureOfDemand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sceneCategories")) {
      Object obj = map.get("sceneCategories");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSceneCategories((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewLabels")) {
      Object obj = map.get("reviewLabels");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewLabels((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("monetaryValue")) {
      Object obj = map.get("monetaryValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMonetaryValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMonetaryValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMonetaryValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMonetaryValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMonetaryValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    if(map.containsKey("taskAndCustomerRelationship.id")) {
        Object obj = map.get("taskAndCustomerRelationship.id");
      if(obj instanceof Long) {
        entity.setTaskAndCustomerRelationshipId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setTaskAndCustomerRelationshipId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("taskAndPeriodizationRelationship.id")) {
        Object obj = map.get("taskAndPeriodizationRelationship.id");
      if(obj instanceof Long) {
        entity.setTaskAndPeriodizationRelationshipId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setTaskAndPeriodizationRelationshipId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("customer_information")) {
      Object obj = map.get("customer_information");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerInformation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("stage_information")) {
      Object obj = map.get("stage_information");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStageInformation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jira_number")) {
      Object obj = map.get("jira_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiraNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("task_describe")) {
      Object obj = map.get("task_describe");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskDescribe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("task_number_key")) {
      Object obj = map.get("task_number_key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskNumberKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("task_level")) {
      Object obj = map.get("task_level");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskLevel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operations_tags")) {
      Object obj = map.get("operations_tags");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperationsTags((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("proposer")) {
      Object obj = map.get("proposer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProposer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("department_the_proposer_belongs")) {
      Object obj = map.get("department_the_proposer_belongs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartmentTheProposerBelongs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("estimated_start_date")) {
      Object obj = map.get("estimated_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEstimatedStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEstimatedStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEstimatedStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEstimatedStartDate(null);
      }
    }
    if(map.containsKey("estimated_end_date")) {
      Object obj = map.get("estimated_end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEstimatedEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEstimatedEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEstimatedEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEstimatedEndDate(null);
      }
    }
    if(map.containsKey("actual_closure_date")) {
      Object obj = map.get("actual_closure_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActualClosureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setActualClosureDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualClosureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setActualClosureDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("task_number_ke2y")) {
      Object obj = map.get("task_number_ke2y");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskNumberKe2y((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pitchStage")) {
      Object obj = map.get("pitchStage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPitchStage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handlingPersonnel")) {
      Object obj = map.get("handlingPersonnel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandlingPersonnel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("proposedTime")) {
      Object obj = map.get("proposedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProposedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setProposedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProposedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setProposedTime(null);
      }
    }
    if(map.containsKey("requirementTitle")) {
      Object obj = map.get("requirementTitle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequirementTitle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("requirementBackground")) {
      Object obj = map.get("requirementBackground");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequirementBackground((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("typeOfValue")) {
      Object obj = map.get("typeOfValue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTypeOfValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("valueSecondaryClassification")) {
      Object obj = map.get("valueSecondaryClassification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValueSecondaryClassification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expectedGoLiveTime")) {
      Object obj = map.get("expectedGoLiveTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpectedGoLiveTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpectedGoLiveTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpectedGoLiveTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpectedGoLiveTime(null);
      }
    }
    if(map.containsKey("judgingTime")) {
      Object obj = map.get("judgingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setJudgingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setJudgingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJudgingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setJudgingTime(null);
      }
    }
    if(map.containsKey("associateRequirementsJIRA")) {
      Object obj = map.get("associateRequirementsJIRA");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssociateRequirementsJIRA((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acceptanceOrNot")) {
      Object obj = map.get("acceptanceOrNot");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAcceptanceOrNot((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("judgingRemark")) {
      Object obj = map.get("judgingRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJudgingRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("judgingConclusions")) {
      Object obj = map.get("judgingConclusions");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJudgingConclusions((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reasonForInvalidation")) {
      Object obj = map.get("reasonForInvalidation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReasonForInvalidation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reasonForFailureAcceptance")) {
      Object obj = map.get("reasonForFailureAcceptance");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReasonForFailureAcceptance((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("circulationStatus")) {
      Object obj = map.get("circulationStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCirculationStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_information_code")) {
      Object obj = map.get("customer_information_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerInformationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("stage_information_code")) {
      Object obj = map.get("stage_information_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStageInformationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_information_id")) {
      Object obj = map.get("customer_information_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerInformationId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("stage_information_id")) {
      Object obj = map.get("stage_information_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStageInformationId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("estimatedDays")) {
      Object obj = map.get("estimatedDays");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEstimatedDays((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acceptanceDate")) {
      Object obj = map.get("acceptanceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcceptanceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcceptanceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcceptanceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcceptanceDate(null);
      }
    }
    if(map.containsKey("riskORNot")) {
      Object obj = map.get("riskORNot");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskORNot((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("typeOfRisk")) {
      Object obj = map.get("typeOfRisk");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTypeOfRisk((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("riskDescription")) {
      Object obj = map.get("riskDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("project_information")) {
      Object obj = map.get("project_information");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectInformation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_sprint_date")) {
      Object obj = map.get("product_sprint_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProductSprintDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setProductSprintDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProductSprintDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setProductSprintDate(null);
      }
    }
    if(map.containsKey("department_the_handling_proposer_belongs")) {
      Object obj = map.get("department_the_handling_proposer_belongs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartmentTheHandlingProposerBelongs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("industry")) {
      Object obj = map.get("industry");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIndustry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectClassification")) {
      Object obj = map.get("projectClassification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectClassification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reimbursementCode")) {
      Object obj = map.get("reimbursementCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReimbursementCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("natureOfDemand")) {
      Object obj = map.get("natureOfDemand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNatureOfDemand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sceneCategories")) {
      Object obj = map.get("sceneCategories");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSceneCategories((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reviewLabels")) {
      Object obj = map.get("reviewLabels");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReviewLabels((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("monetaryValue")) {
      Object obj = map.get("monetaryValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMonetaryValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMonetaryValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMonetaryValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMonetaryValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMonetaryValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
      if(map.containsKey("taskAndCustomerRelationship.id")) {
        Object obj = map.get("taskAndCustomerRelationship.id");
        if(obj instanceof Long) {
          this.setTaskAndCustomerRelationshipId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaskAndCustomerRelationshipId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("taskAndPeriodizationRelationship.id")) {
        Object obj = map.get("taskAndPeriodizationRelationship.id");
        if(obj instanceof Long) {
          this.setTaskAndPeriodizationRelationshipId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaskAndPeriodizationRelationshipId(Long.parseLong((String)obj));
        }
      }
  }
}
