package com.xforceplus.purchaserassist.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-04-02
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoicePlane;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchase-assist")
public interface InvoicePlaneFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoicePlane/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoicePlane ${table.comment}
   * @return R
   */
  @PostMapping("/invoicePlane/add")
  public R save(@RequestBody InvoicePlane invoicePlane);

  /**
   * 修改${table.comment}
   * @param invoicePlane ${table.comment}
   * @return R
   */
  @PostMapping("/invoicePlane/update")
  public R updateById(@RequestBody InvoicePlane invoicePlane);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoicePlane/del/{id}" )
  public R removeById(@PathVariable Long id);

}