package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceVehicle;
import com.xforceplus.purchaserassist.service.IInvoiceVehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-25
 */
@RestController
public class InvoiceVehicleController {

  @Autowired
  private IInvoiceVehicleService invoiceVehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceVehicle ${table.comment}
   * @return
   */
  @GetMapping("/invoicevehicles" )
  public XfR getInvoiceVehicles(XfPage page, InvoiceVehicle invoiceVehicle) {
    return XfR.ok(invoiceVehicleServiceImpl.page(page, Wrappers.query(invoiceVehicle)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicevehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceVehicleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceVehicle ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicevehicles")
  public XfR save(@RequestBody InvoiceVehicle invoiceVehicle) {
     return XfR.ok(invoiceVehicleServiceImpl.save(invoiceVehicle));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceVehicle ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicevehicles/{id}")
  public XfR putUpdate(@RequestBody InvoiceVehicle invoiceVehicle,@PathVariable Long id) {
      invoiceVehicle.setId(id);
      return XfR.ok(invoiceVehicleServiceImpl.updateById(invoiceVehicle));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceVehicle ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicevehicles/{id}")
  public XfR patchUpdate(@RequestBody InvoiceVehicle invoiceVehicle,@PathVariable Long id) {
      InvoiceVehicle upinvoiceVehicle = invoiceVehicleServiceImpl.getById(id);
      if(upinvoiceVehicle != null){
        upinvoiceVehicle = ObjectCopyUtils.copyProperties(invoiceVehicle,upinvoiceVehicle,true);
      }
      return XfR.ok(invoiceVehicleServiceImpl.updateById(upinvoiceVehicle));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicevehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceVehicleServiceImpl.removeById(id));
  }

}