package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceCollectionInfo;
import com.xforceplus.purchaserassist.service.IInvoiceCollectionInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoiceCollectionInfoController {

  @Autowired
  private IInvoiceCollectionInfoService invoiceCollectionInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceCollectionInfo ${table.comment}
   * @return
   */
  @GetMapping("/invoicecollectioninfos" )
  public XfR getInvoiceCollectionInfos(XfPage page, InvoiceCollectionInfo invoiceCollectionInfo) {
    return XfR.ok(invoiceCollectionInfoServiceImpl.page(page, Wrappers.query(invoiceCollectionInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicecollectioninfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceCollectionInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceCollectionInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicecollectioninfos")
  public XfR save(@RequestBody InvoiceCollectionInfo invoiceCollectionInfo) {
     return XfR.ok(invoiceCollectionInfoServiceImpl.save(invoiceCollectionInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceCollectionInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicecollectioninfos/{id}")
  public XfR putUpdate(@RequestBody InvoiceCollectionInfo invoiceCollectionInfo,@PathVariable Long id) {
      invoiceCollectionInfo.setId(id);
      return XfR.ok(invoiceCollectionInfoServiceImpl.updateById(invoiceCollectionInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceCollectionInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicecollectioninfos/{id}")
  public XfR patchUpdate(@RequestBody InvoiceCollectionInfo invoiceCollectionInfo,@PathVariable Long id) {
      InvoiceCollectionInfo upinvoiceCollectionInfo = invoiceCollectionInfoServiceImpl.getById(id);
      if(upinvoiceCollectionInfo != null){
        upinvoiceCollectionInfo = ObjectCopyUtils.copyProperties(invoiceCollectionInfo,upinvoiceCollectionInfo,true);
      }
      return XfR.ok(invoiceCollectionInfoServiceImpl.updateById(upinvoiceCollectionInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicecollectioninfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceCollectionInfoServiceImpl.removeById(id));
  }

}