package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceInfo;
import com.xforceplus.purchaserassist.service.IInvoiceInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoiceInfoController {

  @Autowired
  private IInvoiceInfoService invoiceInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceInfo ${table.comment}
   * @return
   */
  @GetMapping("/invoiceinfos" )
  public XfR getInvoiceInfos(XfPage page, InvoiceInfo invoiceInfo) {
    return XfR.ok(invoiceInfoServiceImpl.page(page, Wrappers.query(invoiceInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceinfos")
  public XfR save(@RequestBody InvoiceInfo invoiceInfo) {
     return XfR.ok(invoiceInfoServiceImpl.save(invoiceInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceinfos/{id}")
  public XfR putUpdate(@RequestBody InvoiceInfo invoiceInfo,@PathVariable Long id) {
      invoiceInfo.setId(id);
      return XfR.ok(invoiceInfoServiceImpl.updateById(invoiceInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceinfos/{id}")
  public XfR patchUpdate(@RequestBody InvoiceInfo invoiceInfo,@PathVariable Long id) {
      InvoiceInfo upinvoiceInfo = invoiceInfoServiceImpl.getById(id);
      if(upinvoiceInfo != null){
        upinvoiceInfo = ObjectCopyUtils.copyProperties(invoiceInfo,upinvoiceInfo,true);
      }
      return XfR.ok(invoiceInfoServiceImpl.updateById(upinvoiceInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceInfoServiceImpl.removeById(id));
  }

}