package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceItem;
import com.xforceplus.purchaserassist.service.IInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoiceItemController {

  @Autowired
  private IInvoiceItemService invoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/invoiceitems" )
  public XfR getInvoiceItems(XfPage page, InvoiceItem invoiceItem) {
    return XfR.ok(invoiceItemServiceImpl.page(page, Wrappers.query(invoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceitems")
  public XfR save(@RequestBody InvoiceItem invoiceItem) {
     return XfR.ok(invoiceItemServiceImpl.save(invoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceitems/{id}")
  public XfR putUpdate(@RequestBody InvoiceItem invoiceItem,@PathVariable Long id) {
      invoiceItem.setId(id);
      return XfR.ok(invoiceItemServiceImpl.updateById(invoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceitems/{id}")
  public XfR patchUpdate(@RequestBody InvoiceItem invoiceItem,@PathVariable Long id) {
      InvoiceItem upinvoiceItem = invoiceItemServiceImpl.getById(id);
      if(upinvoiceItem != null){
        upinvoiceItem = ObjectCopyUtils.copyProperties(invoiceItem,upinvoiceItem,true);
      }
      return XfR.ok(invoiceItemServiceImpl.updateById(upinvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceItemServiceImpl.removeById(id));
  }

}