package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoicePlaneItem;
import com.xforceplus.purchaserassist.service.IInvoicePlaneItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoicePlaneItemController {

  @Autowired
  private IInvoicePlaneItemService invoicePlaneItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicePlaneItem ${table.comment}
   * @return
   */
  @GetMapping("/invoiceplaneitems" )
  public XfR getInvoicePlaneItems(XfPage page, InvoicePlaneItem invoicePlaneItem) {
    return XfR.ok(invoicePlaneItemServiceImpl.page(page, Wrappers.query(invoicePlaneItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceplaneitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicePlaneItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoicePlaneItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceplaneitems")
  public XfR save(@RequestBody InvoicePlaneItem invoicePlaneItem) {
     return XfR.ok(invoicePlaneItemServiceImpl.save(invoicePlaneItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoicePlaneItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceplaneitems/{id}")
  public XfR putUpdate(@RequestBody InvoicePlaneItem invoicePlaneItem,@PathVariable Long id) {
      invoicePlaneItem.setId(id);
      return XfR.ok(invoicePlaneItemServiceImpl.updateById(invoicePlaneItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoicePlaneItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceplaneitems/{id}")
  public XfR patchUpdate(@RequestBody InvoicePlaneItem invoicePlaneItem,@PathVariable Long id) {
      InvoicePlaneItem upinvoicePlaneItem = invoicePlaneItemServiceImpl.getById(id);
      if(upinvoicePlaneItem != null){
        upinvoicePlaneItem = ObjectCopyUtils.copyProperties(invoicePlaneItem,upinvoicePlaneItem,true);
      }
      return XfR.ok(invoicePlaneItemServiceImpl.updateById(upinvoicePlaneItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceplaneitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicePlaneItemServiceImpl.removeById(id));
  }

}