package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceQuota;
import com.xforceplus.purchaserassist.service.IInvoiceQuotaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoiceQuotaController {

  @Autowired
  private IInvoiceQuotaService invoiceQuotaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceQuota ${table.comment}
   * @return
   */
  @GetMapping("/invoicequotas" )
  public XfR getInvoiceQuotas(XfPage page, InvoiceQuota invoiceQuota) {
    return XfR.ok(invoiceQuotaServiceImpl.page(page, Wrappers.query(invoiceQuota)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicequotas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceQuotaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceQuota ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicequotas")
  public XfR save(@RequestBody InvoiceQuota invoiceQuota) {
     return XfR.ok(invoiceQuotaServiceImpl.save(invoiceQuota));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceQuota ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicequotas/{id}")
  public XfR putUpdate(@RequestBody InvoiceQuota invoiceQuota,@PathVariable Long id) {
      invoiceQuota.setId(id);
      return XfR.ok(invoiceQuotaServiceImpl.updateById(invoiceQuota));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceQuota ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicequotas/{id}")
  public XfR patchUpdate(@RequestBody InvoiceQuota invoiceQuota,@PathVariable Long id) {
      InvoiceQuota upinvoiceQuota = invoiceQuotaServiceImpl.getById(id);
      if(upinvoiceQuota != null){
        upinvoiceQuota = ObjectCopyUtils.copyProperties(invoiceQuota,upinvoiceQuota,true);
      }
      return XfR.ok(invoiceQuotaServiceImpl.updateById(upinvoiceQuota));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicequotas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceQuotaServiceImpl.removeById(id));
  }

}