package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceTaxi;
import com.xforceplus.purchaserassist.service.IInvoiceTaxiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoiceTaxiController {

  @Autowired
  private IInvoiceTaxiService invoiceTaxiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceTaxi ${table.comment}
   * @return
   */
  @GetMapping("/invoicetaxis" )
  public XfR getInvoiceTaxis(XfPage page, InvoiceTaxi invoiceTaxi) {
    return XfR.ok(invoiceTaxiServiceImpl.page(page, Wrappers.query(invoiceTaxi)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicetaxis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceTaxiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceTaxi ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicetaxis")
  public XfR save(@RequestBody InvoiceTaxi invoiceTaxi) {
     return XfR.ok(invoiceTaxiServiceImpl.save(invoiceTaxi));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceTaxi ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicetaxis/{id}")
  public XfR putUpdate(@RequestBody InvoiceTaxi invoiceTaxi,@PathVariable Long id) {
      invoiceTaxi.setId(id);
      return XfR.ok(invoiceTaxiServiceImpl.updateById(invoiceTaxi));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceTaxi ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicetaxis/{id}")
  public XfR patchUpdate(@RequestBody InvoiceTaxi invoiceTaxi,@PathVariable Long id) {
      InvoiceTaxi upinvoiceTaxi = invoiceTaxiServiceImpl.getById(id);
      if(upinvoiceTaxi != null){
        upinvoiceTaxi = ObjectCopyUtils.copyProperties(invoiceTaxi,upinvoiceTaxi,true);
      }
      return XfR.ok(invoiceTaxiServiceImpl.updateById(upinvoiceTaxi));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicetaxis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceTaxiServiceImpl.removeById(id));
  }

}