package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceToll;
import com.xforceplus.purchaserassist.service.IInvoiceTollService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoiceTollController {

  @Autowired
  private IInvoiceTollService invoiceTollServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceToll ${table.comment}
   * @return
   */
  @GetMapping("/invoicetolls" )
  public XfR getInvoiceTolls(XfPage page, InvoiceToll invoiceToll) {
    return XfR.ok(invoiceTollServiceImpl.page(page, Wrappers.query(invoiceToll)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicetolls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceTollServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceToll ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicetolls")
  public XfR save(@RequestBody InvoiceToll invoiceToll) {
     return XfR.ok(invoiceTollServiceImpl.save(invoiceToll));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceToll ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicetolls/{id}")
  public XfR putUpdate(@RequestBody InvoiceToll invoiceToll,@PathVariable Long id) {
      invoiceToll.setId(id);
      return XfR.ok(invoiceTollServiceImpl.updateById(invoiceToll));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceToll ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicetolls/{id}")
  public XfR patchUpdate(@RequestBody InvoiceToll invoiceToll,@PathVariable Long id) {
      InvoiceToll upinvoiceToll = invoiceTollServiceImpl.getById(id);
      if(upinvoiceToll != null){
        upinvoiceToll = ObjectCopyUtils.copyProperties(invoiceToll,upinvoiceToll,true);
      }
      return XfR.ok(invoiceTollServiceImpl.updateById(upinvoiceToll));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicetolls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceTollServiceImpl.removeById(id));
  }

}