package com.xforceplus.purchaserassist.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceUsedVehicle;
import com.xforceplus.purchaserassist.service.IInvoiceUsedVehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-04-02
 */
@RestController
public class InvoiceUsedVehicleController {

  @Autowired
  private IInvoiceUsedVehicleService invoiceUsedVehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceUsedVehicle ${table.comment}
   * @return
   */
  @GetMapping("/invoiceusedvehicles" )
  public XfR getInvoiceUsedVehicles(XfPage page, InvoiceUsedVehicle invoiceUsedVehicle) {
    return XfR.ok(invoiceUsedVehicleServiceImpl.page(page, Wrappers.query(invoiceUsedVehicle)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceusedvehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceUsedVehicleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceUsedVehicle ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceusedvehicles")
  public XfR save(@RequestBody InvoiceUsedVehicle invoiceUsedVehicle) {
     return XfR.ok(invoiceUsedVehicleServiceImpl.save(invoiceUsedVehicle));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceUsedVehicle ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceusedvehicles/{id}")
  public XfR putUpdate(@RequestBody InvoiceUsedVehicle invoiceUsedVehicle,@PathVariable Long id) {
      invoiceUsedVehicle.setId(id);
      return XfR.ok(invoiceUsedVehicleServiceImpl.updateById(invoiceUsedVehicle));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceUsedVehicle ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceusedvehicles/{id}")
  public XfR patchUpdate(@RequestBody InvoiceUsedVehicle invoiceUsedVehicle,@PathVariable Long id) {
      InvoiceUsedVehicle upinvoiceUsedVehicle = invoiceUsedVehicleServiceImpl.getById(id);
      if(upinvoiceUsedVehicle != null){
        upinvoiceUsedVehicle = ObjectCopyUtils.copyProperties(invoiceUsedVehicle,upinvoiceUsedVehicle,true);
      }
      return XfR.ok(invoiceUsedVehicleServiceImpl.updateById(upinvoiceUsedVehicle));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceusedvehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceUsedVehicleServiceImpl.removeById(id));
  }

}