package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum BillInvoiceType {

    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    JU("ju", "增值税普通发票(卷票)"),
    CT("ct", "增值税电子普通发票(通行费)"),
    V("v", "机动车统一销售发票"),
    QC("qc", "电子发票（普通发票）"),
    QS("qs", "电子发票（增值税专用发票）"),
    CB("cb", "区块链发票"),
    CD("cd", "通用(电子)发票"),
    CZ("cz", "纸质发票（普通发票）"),
    SZ("sz", "纸质发票（增值税专用发票）"),
    VS("vs", "二手车销售统一发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillInvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "se":
                return SE;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "ct":
                return CT;
            case "v":
                return V;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "cb":
                return CB;
            case "cd":
                return CD;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            case "vs":
                return VS;
            default:
                return null;
        }
    }
}
