package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_exception
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum BizOrderException {

    _1("1", "缺少项目编号"),
    _2("2", "提交销项业务单失败"),
    _3("3", "未查询到项目编号信息"),
    _4("4", "未查询到业务单明细"),
    _5("5", "销项业务单已作废"),
    _6("6", "购方公司未获取");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizOrderException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderException fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
