package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_status_view
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum InvoiceStatusView {

    _1("1", "正常"),
    _2("2", "作废"),
    _3("3", "已红冲"),
    _4("4", "部分红冲"),
    _6("6", "红字发票待确认"),
    _7("7", "异常"),
    _8("8", "失控"),
    _5("5", "全额冲红");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceStatusView(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatusView fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
