package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * original_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum OriginalType {

    INVOICE("invoice", "票转单"),
    BIZ_ORDER("bizOrder", "单转单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OriginalType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OriginalType fromCode(String code){
        switch(code) {
            case "invoice":
                return INVOICE;
            case "bizOrder":
                return BIZ_ORDER;
            default:
                return null;
        }
    }
}
