package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pre_apply_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum PreApplyStatus {

    _1("1", "正常"),
    _2("2", "申请中"),
    _3("3", "申请成功"),
    _4("4", "申请失败"),
    _9("9", "删除"),
    _5("5", "作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PreApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PreApplyStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "9":
                return _9;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
