package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_apply_reason
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum RedApplyReason {

    SALES_ALLOWANCE("sales_allowance", "销售折让"),
    MAKING_ERROR("making_error", "开票有误 "),
    TAXABLE_SERVICE_END("taxable_service_end", "应税服务中止"),
    SALES_RETURN("sales_return", "销货退回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedApplyReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedApplyReason fromCode(String code){
        switch(code) {
            case "sales_allowance":
                return SALES_ALLOWANCE;
            case "making_error":
                return MAKING_ERROR;
            case "taxable_service_end":
                return TAXABLE_SERVICE_END;
            case "sales_return":
                return SALES_RETURN;
            default:
                return null;
        }
    }
}
