package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * scan_back_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum ScanBackFlag {

    _0("0", "无"),
    _1("1", "已退扫"),
    _2("2", "退扫提交");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ScanBackFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ScanBackFlag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
