package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * special_item_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum SpecialItemType {

    SI("SI", "销项"),
    RI("RI", "退项"),
    PA("PA", "正调整单"),
    MA("MA", "负调整单"),
    PG("PG", "赠品");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SpecialItemType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialItemType fromCode(String code){
        switch(code) {
            case "SI":
                return SI;
            case "RI":
                return RI;
            case "PA":
                return PA;
            case "MA":
                return MA;
            case "PG":
                return PG;
            default:
                return null;
        }
    }
}
