package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum Status {

    _0("0", "正常"),
    _1("1", "提交销项业务单成功"),
    _2("2", "提交销项业务单失败"),
    _3("3", "部分开票成功"),
    _4("4", "全部开票成功"),
    _5("5", "销项业务单已作废"),
    _6("6", "已开票"),
    _99("99", "异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
