package com.xforceplus.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_source_view
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum TaxInvoiceSourceView {

    SK("sk", "税控发票"),
    QD("qd", "数电发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxInvoiceSourceView(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSourceView fromCode(String code){
        switch(code) {
            case "sk":
                return SK;
            case "qd":
                return QD;
            default:
                return null;
        }
    }
}
