package com.xforceplus.purchaseresaleservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaseresaleservice.entity.BizOrderOperateHistory;
import com.xforceplus.purchaseresaleservice.service.IBizOrderOperateHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-16
 */
@RestController
public class BizOrderOperateHistoryController {

  @Autowired
  private IBizOrderOperateHistoryService bizOrderOperateHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderOperateHistory ${table.comment}
   * @return
   */
  @GetMapping("/bizorderoperatehistorys" )
  public XfR getBizOrderOperateHistorys(XfPage page, BizOrderOperateHistory bizOrderOperateHistory) {
    return XfR.ok(bizOrderOperateHistoryServiceImpl.page(page, Wrappers.query(bizOrderOperateHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderoperatehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderOperateHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderOperateHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizorderoperatehistorys")
  public XfR save(@RequestBody BizOrderOperateHistory bizOrderOperateHistory) {
     return XfR.ok(bizOrderOperateHistoryServiceImpl.save(bizOrderOperateHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderOperateHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizorderoperatehistorys/{id}")
  public XfR putUpdate(@RequestBody BizOrderOperateHistory bizOrderOperateHistory,@PathVariable Long id) {
      bizOrderOperateHistory.setId(id);
      return XfR.ok(bizOrderOperateHistoryServiceImpl.updateById(bizOrderOperateHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderOperateHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizorderoperatehistorys/{id}")
  public XfR patchUpdate(@RequestBody BizOrderOperateHistory bizOrderOperateHistory,@PathVariable Long id) {
      BizOrderOperateHistory upbizOrderOperateHistory = bizOrderOperateHistoryServiceImpl.getById(id);
      if(upbizOrderOperateHistory != null){
        upbizOrderOperateHistory = ObjectCopyUtils.copyProperties(bizOrderOperateHistory,upbizOrderOperateHistory,true);
      }
      return XfR.ok(bizOrderOperateHistoryServiceImpl.updateById(upbizOrderOperateHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderoperatehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderOperateHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderoperatehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_operate_history");
     params.put("request", condition);

     return XfR.ok(bizOrderOperateHistoryServiceImpl.querys(params));
  }

}
