package com.xforceplus.purchaseresaleservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaseresaleservice.entity.CasInfo;
import com.xforceplus.purchaseresaleservice.service.ICasInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-16
 */
@RestController
public class CasInfoController {

  @Autowired
  private ICasInfoService casInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param casInfo ${table.comment}
   * @return
   */
  @GetMapping("/casinfos" )
  public XfR getCasInfos(XfPage page, CasInfo casInfo) {
    return XfR.ok(casInfoServiceImpl.page(page, Wrappers.query(casInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/casinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(casInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param casInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/casinfos")
  public XfR save(@RequestBody CasInfo casInfo) {
     return XfR.ok(casInfoServiceImpl.save(casInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param casInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/casinfos/{id}")
  public XfR putUpdate(@RequestBody CasInfo casInfo,@PathVariable Long id) {
      casInfo.setId(id);
      return XfR.ok(casInfoServiceImpl.updateById(casInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param casInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/casinfos/{id}")
  public XfR patchUpdate(@RequestBody CasInfo casInfo,@PathVariable Long id) {
      CasInfo upcasInfo = casInfoServiceImpl.getById(id);
      if(upcasInfo != null){
        upcasInfo = ObjectCopyUtils.copyProperties(casInfo,upcasInfo,true);
      }
      return XfR.ok(casInfoServiceImpl.updateById(upcasInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/casinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(casInfoServiceImpl.removeById(id));
  }

  @PostMapping("/casinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cas_info");
     params.put("request", condition);

     return XfR.ok(casInfoServiceImpl.querys(params));
  }

}
