package com.xforceplus.purchaseresaleservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaseresaleservice.entity.PurchaserBizOrder;
import com.xforceplus.purchaseresaleservice.service.IPurchaserBizOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-16
 */
@RestController
public class PurchaserBizOrderController {

  @Autowired
  private IPurchaserBizOrderService purchaserBizOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaserBizOrder ${table.comment}
   * @return
   */
  @GetMapping("/purchaserbizorders" )
  public XfR getPurchaserBizOrders(XfPage page, PurchaserBizOrder purchaserBizOrder) {
    return XfR.ok(purchaserBizOrderServiceImpl.page(page, Wrappers.query(purchaserBizOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaserbizorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaserBizOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaserBizOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaserbizorders")
  public XfR save(@RequestBody PurchaserBizOrder purchaserBizOrder) {
     return XfR.ok(purchaserBizOrderServiceImpl.save(purchaserBizOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaserBizOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaserbizorders/{id}")
  public XfR putUpdate(@RequestBody PurchaserBizOrder purchaserBizOrder,@PathVariable Long id) {
      purchaserBizOrder.setId(id);
      return XfR.ok(purchaserBizOrderServiceImpl.updateById(purchaserBizOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaserBizOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaserbizorders/{id}")
  public XfR patchUpdate(@RequestBody PurchaserBizOrder purchaserBizOrder,@PathVariable Long id) {
      PurchaserBizOrder uppurchaserBizOrder = purchaserBizOrderServiceImpl.getById(id);
      if(uppurchaserBizOrder != null){
        uppurchaserBizOrder = ObjectCopyUtils.copyProperties(purchaserBizOrder,uppurchaserBizOrder,true);
      }
      return XfR.ok(purchaserBizOrderServiceImpl.updateById(uppurchaserBizOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaserbizorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaserBizOrderServiceImpl.removeById(id));
  }

  @PostMapping("/purchaserbizorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchaser_biz_order");
     params.put("request", condition);

     return XfR.ok(purchaserBizOrderServiceImpl.querys(params));
  }

}
