package com.xforceplus.purchaseresaleservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaseresaleservice.entity.PurchaserBizOrderDetail;
import com.xforceplus.purchaseresaleservice.service.IPurchaserBizOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-16
 */
@RestController
public class PurchaserBizOrderDetailController {

  @Autowired
  private IPurchaserBizOrderDetailService purchaserBizOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaserBizOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/purchaserbizorderdetails" )
  public XfR getPurchaserBizOrderDetails(XfPage page, PurchaserBizOrderDetail purchaserBizOrderDetail) {
    return XfR.ok(purchaserBizOrderDetailServiceImpl.page(page, Wrappers.query(purchaserBizOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaserbizorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaserBizOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaserBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaserbizorderdetails")
  public XfR save(@RequestBody PurchaserBizOrderDetail purchaserBizOrderDetail) {
     return XfR.ok(purchaserBizOrderDetailServiceImpl.save(purchaserBizOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaserBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaserbizorderdetails/{id}")
  public XfR putUpdate(@RequestBody PurchaserBizOrderDetail purchaserBizOrderDetail,@PathVariable Long id) {
      purchaserBizOrderDetail.setId(id);
      return XfR.ok(purchaserBizOrderDetailServiceImpl.updateById(purchaserBizOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaserBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaserbizorderdetails/{id}")
  public XfR patchUpdate(@RequestBody PurchaserBizOrderDetail purchaserBizOrderDetail,@PathVariable Long id) {
      PurchaserBizOrderDetail uppurchaserBizOrderDetail = purchaserBizOrderDetailServiceImpl.getById(id);
      if(uppurchaserBizOrderDetail != null){
        uppurchaserBizOrderDetail = ObjectCopyUtils.copyProperties(purchaserBizOrderDetail,uppurchaserBizOrderDetail,true);
      }
      return XfR.ok(purchaserBizOrderDetailServiceImpl.updateById(uppurchaserBizOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaserbizorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaserBizOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/purchaserbizorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchaser_biz_order_detail");
     params.put("request", condition);

     return XfR.ok(purchaserBizOrderDetailServiceImpl.querys(params));
  }

}
