package com.xforceplus.purchaserassist.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-04-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.purchaserassist.entity.InvoiceCollectionInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-assist")
public interface InvoiceCollectionInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceCollectionInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoiceCollectionInfo ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceCollectionInfo/add")
  public R save(@RequestBody InvoiceCollectionInfo invoiceCollectionInfo);

  /**
   * 修改${table.comment}
   * @param invoiceCollectionInfo ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceCollectionInfo/update")
  public R updateById(@RequestBody InvoiceCollectionInfo invoiceCollectionInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceCollectionInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}