package com.xforceplus.purchaserassist.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceCollectionInfo implements Serializable {

  private static final long serialVersionUID=1L;

  private String collectionName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectionTime;

  private BigDecimal collectionAmount;

  private Long collectionNum;

  private Boolean colllectionRepeatFlag;

  private Boolean collectionOccupiedFlag;

  private String collectionExceptionDesc;

  private String collectionInvoiceNoPExcDesc;

  private Boolean collectionExceptionFlag;

  private Boolean collectionMustFlag;

  private Long claimingStatus;

  private Long submitStatus;

  private String submitBatchNo;

  private String submitTaskId;

  private String submitTaskRes;

  private String collectionVerifyTaskid;

  private Long collectionVerifyFlag;

  private String collectionVerifyDesc;

  private String collectionType;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime upateTime;

  private Long collectionStatus;

  private String collectionNo;

  private Long userId;

  private String orgIds;

  private String invoiceNo;

  private String invoiceCode;

  private BigDecimal invoiceAmount;

  private Long invoiceStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceTime;

  private String invoiceType;

  private String invoiceTitle;

  private String invoiceUiqFlag;

  private String documentType;

  private String imgUrl;

  private String discernChannel;

  private Boolean virtualStatus;

  private String purchaseName;

  private String sellerName;

  private Boolean countStatus;

  private String collectionRemark;

  private Long sheetIndex;

  private String regions;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("collection_name", collectionName);
      map.put("collection_time", BocpGenUtils.toTimestamp(collectionTime));
      map.put("collection_amount", collectionAmount);
      map.put("collection_num", collectionNum);
      map.put("colllection_repeat_flag", colllectionRepeatFlag);
      map.put("collection_occupied_flag", collectionOccupiedFlag);
      map.put("collection_exception_desc", collectionExceptionDesc);
      map.put("collection_invoice_no_p_exc_desc", collectionInvoiceNoPExcDesc);
      map.put("collection_exception_flag", collectionExceptionFlag);
      map.put("collection_must_flag", collectionMustFlag);
      map.put("claiming_status", claimingStatus);
      map.put("submit_status", submitStatus);
      map.put("submit_batch_no", submitBatchNo);
      map.put("submit_task_id", submitTaskId);
      map.put("submit_task_res", submitTaskRes);
      map.put("collection_verify_taskid", collectionVerifyTaskid);
      map.put("collection_verify_flag", collectionVerifyFlag);
      map.put("collection_verify_desc", collectionVerifyDesc);
      map.put("collection_type", collectionType);
      map.put("upate_time", BocpGenUtils.toTimestamp(upateTime));
      map.put("collection_status", collectionStatus);
      map.put("collection_no", collectionNo);
      map.put("user_id", userId);
      map.put("org_ids", orgIds);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_amount", invoiceAmount);
      map.put("invoice_status", invoiceStatus);
      map.put("invoice_time", BocpGenUtils.toTimestamp(invoiceTime));
      map.put("invoice_type", invoiceType);
      map.put("invoice_title", invoiceTitle);
      map.put("invoice_uiq_flag", invoiceUiqFlag);
      map.put("document_type", documentType);
      map.put("img_url", imgUrl);
      map.put("discern_channel", discernChannel);
      map.put("virtual_status", virtualStatus);
      map.put("purchase_name", purchaseName);
      map.put("seller_name", sellerName);
      map.put("count_status", countStatus);
      map.put("collection_remark", collectionRemark);
      map.put("sheet_index", sheetIndex);
      map.put("regions", regions);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static InvoiceCollectionInfo fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoiceCollectionInfo entity = new InvoiceCollectionInfo();
    if(map.containsKey("collection_name")) {
      Object obj = map.get("collection_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_time")) {
      Object obj = map.get("collection_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCollectionTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCollectionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectionTime(null);
      }
    }
    if(map.containsKey("collection_amount")) {
      Object obj = map.get("collection_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCollectionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCollectionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCollectionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCollectionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCollectionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("collection_num")) {
      Object obj = map.get("collection_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("colllection_repeat_flag")) {
      Object obj = map.get("colllection_repeat_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setColllectionRepeatFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setColllectionRepeatFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("collection_occupied_flag")) {
      Object obj = map.get("collection_occupied_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCollectionOccupiedFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setCollectionOccupiedFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("collection_exception_desc")) {
      Object obj = map.get("collection_exception_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionExceptionDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_invoice_no_p_exc_desc")) {
      Object obj = map.get("collection_invoice_no_p_exc_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionInvoiceNoPExcDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_exception_flag")) {
      Object obj = map.get("collection_exception_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCollectionExceptionFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setCollectionExceptionFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("collection_must_flag")) {
      Object obj = map.get("collection_must_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCollectionMustFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setCollectionMustFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("claiming_status")) {
      Object obj = map.get("claiming_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setClaimingStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setClaimingStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setClaimingStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("submit_status")) {
      Object obj = map.get("submit_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setSubmitStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSubmitStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("submit_batch_no")) {
      Object obj = map.get("submit_batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_task_id")) {
      Object obj = map.get("submit_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_task_res")) {
      Object obj = map.get("submit_task_res");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitTaskRes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_verify_taskid")) {
      Object obj = map.get("collection_verify_taskid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionVerifyTaskid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_verify_flag")) {
      Object obj = map.get("collection_verify_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionVerifyFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionVerifyFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionVerifyFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_verify_desc")) {
      Object obj = map.get("collection_verify_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionVerifyDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_type")) {
      Object obj = map.get("collection_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upate_time")) {
      Object obj = map.get("upate_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpateTime(null);
      }
    }
    if(map.containsKey("collection_status")) {
      Object obj = map.get("collection_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_no")) {
      Object obj = map.get("collection_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_ids")) {
      Object obj = map.get("org_ids");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgIds((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_amount")) {
      Object obj = map.get("invoice_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceTime(null);
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_title")) {
      Object obj = map.get("invoice_title");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_uiq_flag")) {
      Object obj = map.get("invoice_uiq_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceUiqFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_type")) {
      Object obj = map.get("document_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discern_channel")) {
      Object obj = map.get("discern_channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscernChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtual_status")) {
      Object obj = map.get("virtual_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setVirtualStatus((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setVirtualStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("purchase_name")) {
      Object obj = map.get("purchase_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("count_status")) {
      Object obj = map.get("count_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCountStatus((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setCountStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("collection_remark")) {
      Object obj = map.get("collection_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sheet_index")) {
      Object obj = map.get("sheet_index");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSheetIndex((Long)obj);
        } else if(obj instanceof String) {
          entity.setSheetIndex(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSheetIndex(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("regions")) {
      Object obj = map.get("regions");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
