package com.xforceplus.purchaserassist.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceInfo implements Serializable {

  private static final long serialVersionUID=1L;

  private String invoiceCode;

  private String invoiceNo;

  private String invoiceType;

  private Long specialInvoiceFlag;

  private Long status;

  private String paperDrewDate;

  private String taxRate;

  private BigDecimal amountWithoutTax;

  private BigDecimal taxAmount;

  private BigDecimal amountWithTax;

  private String purchaserName;

  private String purchaserTaxNo;

  private String sellerName;

  private String sellerTaxNo;

  private String machineCode;

  private String checkCode;

  private String cipherText;

  private String cashierName;

  private String checkerName;

  private String invoicerName;

  private String purchaserAddress;

  private String purchaserTel;

  private String purchaserAddrTel;

  private String purchaserBankName;

  private String purchaserBankAccount;

  private String purchaserBankNameAccount;

  private String sellerAddress;

  private String sellerTel;

  private String sellerAddrTel;

  private String sellerBankName;

  private String sellerBankAccount;

  private String sellerBankNameAccount;

  private String remark;

  private String purchaserTenantCode;

  private Long purchaserTenantId;

  private Long purchaserCompanyId;

  private Long purchaserOrgId;

  private Long sellerTenantId;

  private Long sellerCompanyId;

  private Long sellerOrgId;

  private Long redFlag;

  private String redNotificationNo;

  private String veriTaskId;

  private String veriRemark;

  private Long veriStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriRequestTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriResponseTime;

  private Long invoiceOrig;

  private Long isDelete;

  private Long distributeFlag;

  private Long processFlag;

  private Long invoiceFlag;

  private Long discernFlag;

  private Long uniqueFlag;

  private Long collectionId;

  private Long userId;

  private String imgUrl;

  private String invoiceCodeP;

  private String invoiceNoP;

  private String invoiceContent;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_type", invoiceType);
      map.put("special_invoice_flag", specialInvoiceFlag);
      map.put("status", status);
      map.put("paper_drew_date", paperDrewDate);
      map.put("tax_rate", taxRate);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("amount_with_tax", amountWithTax);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("machine_code", machineCode);
      map.put("check_code", checkCode);
      map.put("cipher_text", cipherText);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("purchaser_bank_name_account", purchaserBankNameAccount);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("seller_bank_name_account", sellerBankNameAccount);
      map.put("remark", remark);
      map.put("purchaser_tenant_code", purchaserTenantCode);
      map.put("purchaser_tenant_id", purchaserTenantId);
      map.put("purchaser_company_id", purchaserCompanyId);
      map.put("purchaser_org_id", purchaserOrgId);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("seller_company_id", sellerCompanyId);
      map.put("seller_org_id", sellerOrgId);
      map.put("red_flag", redFlag);
      map.put("red_notification_no", redNotificationNo);
      map.put("veri_task_id", veriTaskId);
      map.put("veri_remark", veriRemark);
      map.put("veri_status", veriStatus);
      map.put("veri_request_time", BocpGenUtils.toTimestamp(veriRequestTime));
      map.put("veri_response_time", BocpGenUtils.toTimestamp(veriResponseTime));
      map.put("invoice_orig", invoiceOrig);
      map.put("is_delete", isDelete);
      map.put("distribute_flag", distributeFlag);
      map.put("process_flag", processFlag);
      map.put("invoice_flag", invoiceFlag);
      map.put("discern_flag", discernFlag);
      map.put("unique_flag", uniqueFlag);
      map.put("collection_id", collectionId);
      map.put("user_id", userId);
      map.put("img_url", imgUrl);
      map.put("invoice_code_p", invoiceCodeP);
      map.put("invoice_no_p", invoiceNoP);
      map.put("invoice_content", invoiceContent);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static InvoiceInfo fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoiceInfo entity = new InvoiceInfo();
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSpecialInvoiceFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setSpecialInvoiceFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSpecialInvoiceFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_code")) {
      Object obj = map.get("purchaser_tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_org_id")) {
      Object obj = map.get("purchaser_org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_company_id")) {
      Object obj = map.get("seller_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_org_id")) {
      Object obj = map.get("seller_org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("red_flag")) {
      Object obj = map.get("red_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_task_id")) {
      Object obj = map.get("veri_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_remark")) {
      Object obj = map.get("veri_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_status")) {
      Object obj = map.get("veri_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("veri_request_time")) {
      Object obj = map.get("veri_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriRequestTime(null);
      }
    }
    if(map.containsKey("veri_response_time")) {
      Object obj = map.get("veri_response_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriResponseTime(null);
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceOrig((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceOrig(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceOrig(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_delete")) {
      Object obj = map.get("is_delete");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsDelete((Long)obj);
        } else if(obj instanceof String) {
          entity.setIsDelete(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setIsDelete(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("distribute_flag")) {
      Object obj = map.get("distribute_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDistributeFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setDistributeFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDistributeFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("process_flag")) {
      Object obj = map.get("process_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProcessFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setProcessFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setProcessFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("discern_flag")) {
      Object obj = map.get("discern_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDiscernFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setDiscernFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDiscernFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unique_flag")) {
      Object obj = map.get("unique_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUniqueFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setUniqueFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUniqueFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_id")) {
      Object obj = map.get("collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code_p")) {
      Object obj = map.get("invoice_code_p");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCodeP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no_p")) {
      Object obj = map.get("invoice_no_p");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_content")) {
      Object obj = map.get("invoice_content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
