package com.xforceplus.purchaserassist.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoicePlane implements Serializable {

  private static final long serialVersionUID=1L;

  private String nameOfPassenger;

  private String idNo;

  private String endorsements;

  private String serialNo;

  private String eTicketNo;

  private String checkCode;

  private String information;

  private String agentCode;

  private String issuedBy;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dateOfIssue;

  private BigDecimal insurance;

  private BigDecimal fare;

  private BigDecimal caacDevelopmentFund;

  private BigDecimal fuelSurcharge;

  private BigDecimal total;

  private BigDecimal tax;

  private Long status;

  private Long collectionId;

  private Long userId;

  private String planFrom;

  private String planTo;

  private String flight;

  private String date;

  private String time;

  private String passengerClass;

  private String fareBasis;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceTime;

  private String imgUrl;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("name_of_passenger", nameOfPassenger);
      map.put("id_no", idNo);
      map.put("endorsements", endorsements);
      map.put("serial_no", serialNo);
      map.put("e_ticket_no", eTicketNo);
      map.put("check_code", checkCode);
      map.put("information", information);
      map.put("agent_code", agentCode);
      map.put("issued_by", issuedBy);
      map.put("date_of_issue", BocpGenUtils.toTimestamp(dateOfIssue));
      map.put("insurance", insurance);
      map.put("fare", fare);
      map.put("caac_development_fund", caacDevelopmentFund);
      map.put("fuel_surcharge", fuelSurcharge);
      map.put("total", total);
      map.put("tax", tax);
      map.put("status", status);
      map.put("collection_id", collectionId);
      map.put("user_id", userId);
      map.put("plan_from", planFrom);
      map.put("plan_to", planTo);
      map.put("flight", flight);
      map.put("date", date);
      map.put("time", time);
      map.put("passenger_class", passengerClass);
      map.put("fare_basis", fareBasis);
      map.put("invoice_time", BocpGenUtils.toTimestamp(invoiceTime));
      map.put("img_url", imgUrl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static InvoicePlane fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoicePlane entity = new InvoicePlane();
    if(map.containsKey("name_of_passenger")) {
      Object obj = map.get("name_of_passenger");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNameOfPassenger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id_no")) {
      Object obj = map.get("id_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endorsements")) {
      Object obj = map.get("endorsements");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEndorsements((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_no")) {
      Object obj = map.get("serial_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("e_ticket_no")) {
      Object obj = map.get("e_ticket_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setETicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("information")) {
      Object obj = map.get("information");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agent_code")) {
      Object obj = map.get("agent_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issued_by")) {
      Object obj = map.get("issued_by");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssuedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date_of_issue")) {
      Object obj = map.get("date_of_issue");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDateOfIssue((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDateOfIssue(null);
      }
    }
    if(map.containsKey("insurance")) {
      Object obj = map.get("insurance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInsurance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInsurance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInsurance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInsurance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInsurance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fare")) {
      Object obj = map.get("fare");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFare((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFare(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFare(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFare(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFare(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("caac_development_fund")) {
      Object obj = map.get("caac_development_fund");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCaacDevelopmentFund((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCaacDevelopmentFund(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCaacDevelopmentFund(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCaacDevelopmentFund(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCaacDevelopmentFund(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fuel_surcharge")) {
      Object obj = map.get("fuel_surcharge");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFuelSurcharge((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFuelSurcharge(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFuelSurcharge(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFuelSurcharge(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFuelSurcharge(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_id")) {
      Object obj = map.get("collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("plan_from")) {
      Object obj = map.get("plan_from");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlanFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plan_to")) {
      Object obj = map.get("plan_to");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlanTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flight")) {
      Object obj = map.get("flight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFlight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("time")) {
      Object obj = map.get("time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("passenger_class")) {
      Object obj = map.get("passenger_class");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPassengerClass((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fare_basis")) {
      Object obj = map.get("fare_basis");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFareBasis((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceTime(null);
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
