package com.xforceplus.purchaserassist.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceTrain implements Serializable {

  private static final long serialVersionUID=1L;

  private String trains;

  private String startStation;

  private String endStation;

  private String date;

  private String time;

  private String seat;

  private String seatType;

  private BigDecimal price;

  private String certificateNo;

  private String name;

  private String no;

  private String qrcode;

  private Long status;

  private Long collectionId;

  private Long userId;

  private String imgUrl;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("trains", trains);
      map.put("start_station", startStation);
      map.put("end_station", endStation);
      map.put("date", date);
      map.put("time", time);
      map.put("seat", seat);
      map.put("seat_type", seatType);
      map.put("price", price);
      map.put("certificate_no", certificateNo);
      map.put("name", name);
      map.put("no", no);
      map.put("qrcode", qrcode);
      map.put("status", status);
      map.put("collection_id", collectionId);
      map.put("user_id", userId);
      map.put("img_url", imgUrl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static InvoiceTrain fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoiceTrain entity = new InvoiceTrain();
    if(map.containsKey("trains")) {
      Object obj = map.get("trains");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTrains((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_station")) {
      Object obj = map.get("start_station");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStartStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("end_station")) {
      Object obj = map.get("end_station");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEndStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("time")) {
      Object obj = map.get("time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat_type")) {
      Object obj = map.get("seat_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeatType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("certificate_no")) {
      Object obj = map.get("certificate_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCertificateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no")) {
      Object obj = map.get("no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qrcode")) {
      Object obj = map.get("qrcode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQrcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_id")) {
      Object obj = map.get("collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
