package com.xforceplus.purchaserassist.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceUsedVehicle implements Serializable {

  private static final long serialVersionUID=1L;

  private String invoiceNo;

  private String invoiceCode;

  private String invoiceType;

  private String paperDrewDate;

  private String registrationNo;

  private BigDecimal totalPrice;

  private String vehicleNo;

  private String vehicleBrand;

  private String vehiclePlaceName;

  private String sellerName;

  private String sellerTaxNo;

  private String sellerAddress;

  private String sellerTel;

  private String auctioneersName;

  private String auctioneersAddress;

  private String auctioneersTaxNo;

  private String auctioneersBankInfo;

  private String auctioneersTel;

  private String usedCarMarketName;

  private String usedCarMarketAddress;

  private String usedCarMarketTaxNo;

  private String usedCarMarketBankInfo;

  private String usedCarMarketTel;

  private String remark;

  private String checkNumber;

  private String machineCode;

  private String purchaserName;

  private String purchaserTaxNo;

  private String purchaserAddress;

  private String purchaserTel;

  private String carNumber;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceTime;

  private Long userId;

  private Long collectionId;

  private Boolean redFlag;

  private Long status;

  private Long invoiceOrig;

  private String imgUrl;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  private String veriTaskId;

  private String veriRemark;

  private Long veriStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriRequestTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriResponseTime;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_type", invoiceType);
      map.put("paper_drew_date", paperDrewDate);
      map.put("registration_no", registrationNo);
      map.put("total_price", totalPrice);
      map.put("vehicle_no", vehicleNo);
      map.put("vehicle_brand", vehicleBrand);
      map.put("vehicle_place_name", vehiclePlaceName);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("auctioneers_name", auctioneersName);
      map.put("auctioneers_address", auctioneersAddress);
      map.put("auctioneers_tax_no", auctioneersTaxNo);
      map.put("auctioneers_bank_info", auctioneersBankInfo);
      map.put("auctioneers_tel", auctioneersTel);
      map.put("used_car_market_name", usedCarMarketName);
      map.put("used_car_market_address", usedCarMarketAddress);
      map.put("used_car_market_tax_no", usedCarMarketTaxNo);
      map.put("used_car_market_bank_info", usedCarMarketBankInfo);
      map.put("used_car_market_tel", usedCarMarketTel);
      map.put("remark", remark);
      map.put("check_number", checkNumber);
      map.put("machine_code", machineCode);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("car_number", carNumber);
      map.put("invoice_time", BocpGenUtils.toTimestamp(invoiceTime));
      map.put("user_id", userId);
      map.put("collection_id", collectionId);
      map.put("red_flag", redFlag);
      map.put("status", status);
      map.put("invoice_orig", invoiceOrig);
      map.put("img_url", imgUrl);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("veri_task_id", veriTaskId);
      map.put("veri_remark", veriRemark);
      map.put("veri_status", veriStatus);
      map.put("veri_request_time", BocpGenUtils.toTimestamp(veriRequestTime));
      map.put("veri_response_time", BocpGenUtils.toTimestamp(veriResponseTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static InvoiceUsedVehicle fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoiceUsedVehicle entity = new InvoiceUsedVehicle();
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("registration_no")) {
      Object obj = map.get("registration_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegistrationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_price")) {
      Object obj = map.get("total_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_place_name")) {
      Object obj = map.get("vehicle_place_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehiclePlaceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_name")) {
      Object obj = map.get("auctioneers_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuctioneersName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_address")) {
      Object obj = map.get("auctioneers_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuctioneersAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_tax_no")) {
      Object obj = map.get("auctioneers_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuctioneersTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_bank_info")) {
      Object obj = map.get("auctioneers_bank_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuctioneersBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_tel")) {
      Object obj = map.get("auctioneers_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuctioneersTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_name")) {
      Object obj = map.get("used_car_market_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsedCarMarketName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_address")) {
      Object obj = map.get("used_car_market_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsedCarMarketAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_tax_no")) {
      Object obj = map.get("used_car_market_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsedCarMarketTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_bank_info")) {
      Object obj = map.get("used_car_market_bank_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsedCarMarketBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_tel")) {
      Object obj = map.get("used_car_market_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsedCarMarketTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_number")) {
      Object obj = map.get("check_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("car_number")) {
      Object obj = map.get("car_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCarNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceTime(null);
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_id")) {
      Object obj = map.get("collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("red_flag")) {
      Object obj = map.get("red_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRedFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setRedFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceOrig((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceOrig(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceOrig(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("veri_task_id")) {
      Object obj = map.get("veri_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_remark")) {
      Object obj = map.get("veri_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_status")) {
      Object obj = map.get("veri_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("veri_request_time")) {
      Object obj = map.get("veri_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriRequestTime(null);
      }
    }
    if(map.containsKey("veri_response_time")) {
      Object obj = map.get("veri_response_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriResponseTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
