package com.xforceplus.purchaserassist.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceVehicle implements Serializable {

  private static final long serialVersionUID=1L;

  private String invoiceCode;

  private String invoiceNo;

  private String invoiceType;

  private Long status;

  private String paperDrewDate;

  private String taxRate;

  private BigDecimal amountWithoutTax;

  private BigDecimal taxAmount;

  private BigDecimal amountWithTax;

  private String purchaserName;

  private String purchaserTaxNo;

  private String sellerName;

  private String sellerTaxNo;

  private String machineCode;

  private String checkCode;

  private String cipherText;

  private String cashierName;

  private String checkerName;

  private String invoicerName;

  private String purchaserAddress;

  private String sellerAddress;

  private String sellerTel;

  private String sellerAddrTel;

  private String sellerBankName;

  private String sellerBankAccount;

  private String sellerBankInfo;

  private String purchaserId;

  private String vehicleType;

  private String vehicleBrand;

  private String productionArea;

  private String engineNo;

  private String commodityInspectionNo;

  private String certificationNo;

  private String vehicleNo;

  private String importCertificateNo;

  private String chargeTaxAuthorityCode;

  private String chargeTaxAuthorityName;

  private String taxPaidProof;

  private String tonnage;

  private String maxCapacity;

  private String checkNumber;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  private String dqCode;

  private String dqName;

  private String remark;

  private Long redFlag;

  private String redNotificationNo;

  private String veriTaskId;

  private String veriRemark;

  private Long veriStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriRequestTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriResponseTime;

  private Long invoiceOrig;

  private Long collectionId;

  private Long userId;

  private String imgUrl;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_type", invoiceType);
      map.put("status", status);
      map.put("paper_drew_date", paperDrewDate);
      map.put("tax_rate", taxRate);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("amount_with_tax", amountWithTax);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("machine_code", machineCode);
      map.put("check_code", checkCode);
      map.put("cipher_text", cipherText);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("purchaser_address", purchaserAddress);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("seller_bank_info", sellerBankInfo);
      map.put("purchaser_id", purchaserId);
      map.put("vehicle_type", vehicleType);
      map.put("vehicle_brand", vehicleBrand);
      map.put("production_area", productionArea);
      map.put("engine_no", engineNo);
      map.put("commodity_inspection_no", commodityInspectionNo);
      map.put("certification_no", certificationNo);
      map.put("vehicle_no", vehicleNo);
      map.put("import_certificate_no", importCertificateNo);
      map.put("charge_tax_authority_code", chargeTaxAuthorityCode);
      map.put("charge_tax_authority_name", chargeTaxAuthorityName);
      map.put("tax_paid_proof", taxPaidProof);
      map.put("tonnage", tonnage);
      map.put("max_capacity", maxCapacity);
      map.put("check_number", checkNumber);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("dq_code", dqCode);
      map.put("dq_name", dqName);
      map.put("remark", remark);
      map.put("red_flag", redFlag);
      map.put("red_notification_no", redNotificationNo);
      map.put("veri_task_id", veriTaskId);
      map.put("veri_remark", veriRemark);
      map.put("veri_status", veriStatus);
      map.put("veri_request_time", BocpGenUtils.toTimestamp(veriRequestTime));
      map.put("veri_response_time", BocpGenUtils.toTimestamp(veriResponseTime));
      map.put("invoice_orig", invoiceOrig);
      map.put("collection_id", collectionId);
      map.put("user_id", userId);
      map.put("img_url", imgUrl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static InvoiceVehicle fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoiceVehicle entity = new InvoiceVehicle();
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_info")) {
      Object obj = map.get("seller_bank_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_id")) {
      Object obj = map.get("purchaser_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductionArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEngineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commodity_inspection_no")) {
      Object obj = map.get("commodity_inspection_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommodityInspectionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("certification_no")) {
      Object obj = map.get("certification_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCertificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_certificate_no")) {
      Object obj = map.get("import_certificate_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImportCertificateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_tax_authority_code")) {
      Object obj = map.get("charge_tax_authority_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeTaxAuthorityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_tax_authority_name")) {
      Object obj = map.get("charge_tax_authority_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeTaxAuthorityName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPaidProof((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaxCapacity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_number")) {
      Object obj = map.get("check_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("dq_code")) {
      Object obj = map.get("dq_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDqCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dq_name")) {
      Object obj = map.get("dq_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDqName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_flag")) {
      Object obj = map.get("red_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_task_id")) {
      Object obj = map.get("veri_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_remark")) {
      Object obj = map.get("veri_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_status")) {
      Object obj = map.get("veri_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("veri_request_time")) {
      Object obj = map.get("veri_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriRequestTime(null);
      }
    }
    if(map.containsKey("veri_response_time")) {
      Object obj = map.get("veri_response_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriResponseTime(null);
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceOrig((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceOrig(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceOrig(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_id")) {
      Object obj = map.get("collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
