package com.xforceplus.purchaserassist.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceVehicleOld implements Serializable {

  private static final long serialVersionUID=1L;

  private String vehicleBrand;

  private String origin;

  private String qualifiedNumber;

  private String bookNo;

  private String checkNo;

  private String engineNumber;

  private String identificationNumber;

  private String tonnage;

  private Long maxCapacity;

  private String invoiceCode;

  private String invoiceNo;

  private String invoiceType;

  private BigDecimal totalAmountTaxNum;

  private BigDecimal totalAmount;

  private BigDecimal totalTax;

  private BigDecimal taxRate;

  private String paperDrewDate;

  private String sellerTaxNo;

  private String drawer;

  private String sellerName;

  private String sellerAddr;

  private String sellerTel;

  private String sellerBank;

  private String sellerBankNo;

  private String purchaserTaxNo;

  private String purchaserName;

  private String purchaserIdCode;

  private String codeOfTheCompetentTaxAuthority;

  private String nameOfTheCompetentTaxAuthority;

  private String taxPaidProof;

  private String qrcode;

  private String vehiclesType;

  private String machineCode;

  private String checkCode;

  private String sku;

  private String cipherList;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceTime;

  private Long userId;

  private Long collectionId;

  private Long status;

  private Long invoiceOrig;

  private String imgUrl;

  private String veriTaskId;

  private String veriRemark;

  private Long veriStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriRequestTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriResponseTime;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("vehicle_brand", vehicleBrand);
      map.put("origin", origin);
      map.put("qualified_number", qualifiedNumber);
      map.put("book_no", bookNo);
      map.put("check_no", checkNo);
      map.put("engine_number", engineNumber);
      map.put("identification_number", identificationNumber);
      map.put("tonnage", tonnage);
      map.put("max_capacity", maxCapacity);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_type", invoiceType);
      map.put("total_amount_tax_num", totalAmountTaxNum);
      map.put("total_amount", totalAmount);
      map.put("total_tax", totalTax);
      map.put("tax_rate", taxRate);
      map.put("paper_drew_date", paperDrewDate);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("drawer", drawer);
      map.put("seller_name", sellerName);
      map.put("seller_addr", sellerAddr);
      map.put("seller_tel", sellerTel);
      map.put("seller_bank", sellerBank);
      map.put("seller_bank_no", sellerBankNo);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_id_code", purchaserIdCode);
      map.put("code_of_the_competent_tax_authority", codeOfTheCompetentTaxAuthority);
      map.put("name_of_the_competent_tax_authority", nameOfTheCompetentTaxAuthority);
      map.put("tax_paid_proof", taxPaidProof);
      map.put("qrcode", qrcode);
      map.put("vehicles_type", vehiclesType);
      map.put("machine_code", machineCode);
      map.put("check_code", checkCode);
      map.put("sku", sku);
      map.put("cipher_list", cipherList);
      map.put("invoice_time", BocpGenUtils.toTimestamp(invoiceTime));
      map.put("user_id", userId);
      map.put("collection_id", collectionId);
      map.put("status", status);
      map.put("invoice_orig", invoiceOrig);
      map.put("img_url", imgUrl);
      map.put("veri_task_id", veriTaskId);
      map.put("veri_remark", veriRemark);
      map.put("veri_status", veriStatus);
      map.put("veri_request_time", BocpGenUtils.toTimestamp(veriRequestTime));
      map.put("veri_response_time", BocpGenUtils.toTimestamp(veriResponseTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static InvoiceVehicleOld fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoiceVehicleOld entity = new InvoiceVehicleOld();
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin")) {
      Object obj = map.get("origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qualified_number")) {
      Object obj = map.get("qualified_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQualifiedNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("book_no")) {
      Object obj = map.get("book_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBookNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_no")) {
      Object obj = map.get("check_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("engine_number")) {
      Object obj = map.get("engine_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEngineNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("identification_number")) {
      Object obj = map.get("identification_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIdentificationNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMaxCapacity((Long)obj);
        } else if(obj instanceof String) {
          entity.setMaxCapacity(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMaxCapacity(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_amount_tax_num")) {
      Object obj = map.get("total_amount_tax_num");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmountTaxNum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmountTaxNum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmountTaxNum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmountTaxNum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmountTaxNum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_tax")) {
      Object obj = map.get("total_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("drawer")) {
      Object obj = map.get("drawer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDrawer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr")) {
      Object obj = map.get("seller_addr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank")) {
      Object obj = map.get("seller_bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_no")) {
      Object obj = map.get("seller_bank_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_id_code")) {
      Object obj = map.get("purchaser_id_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserIdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("code_of_the_competent_tax_authority")) {
      Object obj = map.get("code_of_the_competent_tax_authority");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCodeOfTheCompetentTaxAuthority((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name_of_the_competent_tax_authority")) {
      Object obj = map.get("name_of_the_competent_tax_authority");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNameOfTheCompetentTaxAuthority((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPaidProof((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qrcode")) {
      Object obj = map.get("qrcode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQrcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicles_type")) {
      Object obj = map.get("vehicles_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehiclesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku")) {
      Object obj = map.get("sku");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSku((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_list")) {
      Object obj = map.get("cipher_list");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceTime(null);
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collection_id")) {
      Object obj = map.get("collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceOrig((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceOrig(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceOrig(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_task_id")) {
      Object obj = map.get("veri_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_remark")) {
      Object obj = map.get("veri_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_status")) {
      Object obj = map.get("veri_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("veri_request_time")) {
      Object obj = map.get("veri_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriRequestTime(null);
      }
    }
    if(map.containsKey("veri_response_time")) {
      Object obj = map.get("veri_response_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVeriResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriResponseTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
