package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 功能点配置对象feign客户端
 *
 * @author ultraman
 * @date 2025-04-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.FunctionConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface FunctionConfigFeignApi {

  /**
   * 通过id查询功能点配置对象
   * @param  id
   * @return R
   */
  @GetMapping("/functionConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增功能点配置对象
   * @param functionConfig 功能点配置对象
   * @return R
   */
  @PostMapping("/functionConfig/add")
  public R save(@RequestBody FunctionConfig functionConfig);

  /**
   * 修改功能点配置对象
   * @param functionConfig 功能点配置对象
   * @return R
   */
  @PostMapping("/functionConfig/update")
  public R updateById(@RequestBody FunctionConfig functionConfig);

  /**
   * 通过id删除功能点配置对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/functionConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}