package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 配置功能feign客户端
 *
 * @author ultraman
 * @date 2025-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.BusinessConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface BusinessConfigFeignApi {

  /**
   * 通过id查询配置功能
   * @param  id
   * @return R
   */
  @GetMapping("/businessConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增配置功能
   * @param businessConfig 配置功能
   * @return R
   */
  @PostMapping("/businessConfig/add")
  public R save(@RequestBody BusinessConfig businessConfig);

  /**
   * 修改配置功能
   * @param businessConfig 配置功能
   * @return R
   */
  @PostMapping("/businessConfig/update")
  public R updateById(@RequestBody BusinessConfig businessConfig);

  /**
   * 通过id删除配置功能
   * @param  id
   * @return R
   */
  @DeleteMapping("/businessConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}