package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 发票不合规对象信息feign客户端
 *
 * @author ultraman
 * @date 2025-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceNoCompliance;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceNoComplianceFeignApi {

  /**
   * 通过id查询发票不合规对象信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceNoCompliance/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票不合规对象信息
   * @param invoiceNoCompliance 发票不合规对象信息
   * @return R
   */
  @PostMapping("/invoiceNoCompliance/add")
  public R save(@RequestBody InvoiceNoCompliance invoiceNoCompliance);

  /**
   * 修改发票不合规对象信息
   * @param invoiceNoCompliance 发票不合规对象信息
   * @return R
   */
  @PostMapping("/invoiceNoCompliance/update")
  public R updateById(@RequestBody InvoiceNoCompliance invoiceNoCompliance);

  /**
   * 通过id删除发票不合规对象信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceNoCompliance/del/{id}" )
  public R removeById(@PathVariable Long id);

}