package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 发票识别相关信息feign客户端
 *
 * @author ultraman
 * @date 2025-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceRecog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceRecogFeignApi {

  /**
   * 通过id查询发票识别相关信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRecog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票识别相关信息
   * @param invoiceRecog 发票识别相关信息
   * @return R
   */
  @PostMapping("/invoiceRecog/add")
  public R save(@RequestBody InvoiceRecog invoiceRecog);

  /**
   * 修改发票识别相关信息
   * @param invoiceRecog 发票识别相关信息
   * @return R
   */
  @PostMapping("/invoiceRecog/update")
  public R updateById(@RequestBody InvoiceRecog invoiceRecog);

  /**
   * 通过id删除发票识别相关信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRecog/del/{id}" )
  public R removeById(@PathVariable Long id);

}