package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 行程单明细对象feign客户端
 *
 * @author ultraman
 * @date 2025-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.TravelTicketItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface TravelTicketItemFeignApi {

  /**
   * 通过id查询行程单明细对象
   * @param  id
   * @return R
   */
  @GetMapping("/travelTicketItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增行程单明细对象
   * @param travelTicketItem 行程单明细对象
   * @return R
   */
  @PostMapping("/travelTicketItem/add")
  public R save(@RequestBody TravelTicketItem travelTicketItem);

  /**
   * 修改行程单明细对象
   * @param travelTicketItem 行程单明细对象
   * @return R
   */
  @PostMapping("/travelTicketItem/update")
  public R updateById(@RequestBody TravelTicketItem travelTicketItem);

  /**
   * 通过id删除行程单明细对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/travelTicketItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}