package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 发票旅客运输服务对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoicePassengerTransportations;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoicePassengerTransportationsFeignApi {

  /**
   * 通过id查询发票旅客运输服务对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoicePassengerTransportations/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票旅客运输服务对象
   * @param invoicePassengerTransportations 发票旅客运输服务对象
   * @return R
   */
  @PostMapping("/invoicePassengerTransportations/add")
  public R save(@RequestBody InvoicePassengerTransportations invoicePassengerTransportations);

  /**
   * 修改发票旅客运输服务对象
   * @param invoicePassengerTransportations 发票旅客运输服务对象
   * @return R
   */
  @PostMapping("/invoicePassengerTransportations/update")
  public R updateById(@RequestBody InvoicePassengerTransportations invoicePassengerTransportations);

  /**
   * 通过id删除发票旅客运输服务对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoicePassengerTransportations/del/{id}" )
  public R removeById(@PathVariable Long id);

}