package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 发票不动产销售对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceRealEstateSales;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceRealEstateSalesFeignApi {

  /**
   * 通过id查询发票不动产销售对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRealEstateSales/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票不动产销售对象
   * @param invoiceRealEstateSales 发票不动产销售对象
   * @return R
   */
  @PostMapping("/invoiceRealEstateSales/add")
  public R save(@RequestBody InvoiceRealEstateSales invoiceRealEstateSales);

  /**
   * 修改发票不动产销售对象
   * @param invoiceRealEstateSales 发票不动产销售对象
   * @return R
   */
  @PostMapping("/invoiceRealEstateSales/update")
  public R updateById(@RequestBody InvoiceRealEstateSales invoiceRealEstateSales);

  /**
   * 通过id删除发票不动产销售对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRealEstateSales/del/{id}" )
  public R removeById(@PathVariable Long id);

}