package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 配单下发模块feign客户端
 *
 * @author ultraman
 * @date 2025-10-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.MatchBatchSend;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface MatchBatchSendFeignApi {

  /**
   * 通过id查询配单下发模块
   * @param  id
   * @return R
   */
  @GetMapping("/matchBatchSend/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增配单下发模块
   * @param matchBatchSend 配单下发模块
   * @return R
   */
  @PostMapping("/matchBatchSend/add")
  public R save(@RequestBody MatchBatchSend matchBatchSend);

  /**
   * 修改配单下发模块
   * @param matchBatchSend 配单下发模块
   * @return R
   */
  @PostMapping("/matchBatchSend/update")
  public R updateById(@RequestBody MatchBatchSend matchBatchSend);

  /**
   * 通过id删除配单下发模块
   * @param  id
   * @return R
   */
  @DeleteMapping("/matchBatchSend/del/{id}" )
  public R removeById(@PathVariable Long id);

}