package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 发票代征车船税对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceVehicleAndVesselTax;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceVehicleAndVesselTaxFeignApi {

  /**
   * 通过id查询发票代征车船税对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceVehicleAndVesselTax/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票代征车船税对象
   * @param invoiceVehicleAndVesselTax 发票代征车船税对象
   * @return R
   */
  @PostMapping("/invoiceVehicleAndVesselTax/add")
  public R save(@RequestBody InvoiceVehicleAndVesselTax invoiceVehicleAndVesselTax);

  /**
   * 修改发票代征车船税对象
   * @param invoiceVehicleAndVesselTax 发票代征车船税对象
   * @return R
   */
  @PostMapping("/invoiceVehicleAndVesselTax/update")
  public R updateById(@RequestBody InvoiceVehicleAndVesselTax invoiceVehicleAndVesselTax);

  /**
   * 通过id删除发票代征车船税对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceVehicleAndVesselTax/del/{id}" )
  public R removeById(@PathVariable Long id);

}