package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 验真发票提示对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceVerifyPrompt;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceVerifyPromptFeignApi {

  /**
   * 通过id查询验真发票提示对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceVerifyPrompt/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增验真发票提示对象
   * @param invoiceVerifyPrompt 验真发票提示对象
   * @return R
   */
  @PostMapping("/invoiceVerifyPrompt/add")
  public R save(@RequestBody InvoiceVerifyPrompt invoiceVerifyPrompt);

  /**
   * 修改验真发票提示对象
   * @param invoiceVerifyPrompt 验真发票提示对象
   * @return R
   */
  @PostMapping("/invoiceVerifyPrompt/update")
  public R updateById(@RequestBody InvoiceVerifyPrompt invoiceVerifyPrompt);

  /**
   * 通过id删除验真发票提示对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceVerifyPrompt/del/{id}" )
  public R removeById(@PathVariable Long id);

}