package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 租户功能配置对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.TenantFunctionConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface TenantFunctionConfigFeignApi {

  /**
   * 通过id查询租户功能配置对象
   * @param  id
   * @return R
   */
  @GetMapping("/tenantFunctionConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增租户功能配置对象
   * @param tenantFunctionConfig 租户功能配置对象
   * @return R
   */
  @PostMapping("/tenantFunctionConfig/add")
  public R save(@RequestBody TenantFunctionConfig tenantFunctionConfig);

  /**
   * 修改租户功能配置对象
   * @param tenantFunctionConfig 租户功能配置对象
   * @return R
   */
  @PostMapping("/tenantFunctionConfig/update")
  public R updateById(@RequestBody TenantFunctionConfig tenantFunctionConfig);

  /**
   * 通过id删除租户功能配置对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/tenantFunctionConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}